---
id: styling
title: Styling PhotoSwipe
sidebar_label: Styling
---


## Modifying icons

By default PhotoSwipe includes Close, Zoom and Arrow icon (right arrow is flipped left arrow). Each is an SVG element that is generated by JavaScript. 

Default icons contain an outline/shadow so the icon is visible on both dark and light background (to disable it add style `.pswp__icn-shadow { display: none }`).

To modify the color of the icons use CSS variables. To modify SVG shapes use JS options: `arrowPrevSVG`, `arrowNextSVG`, `closeSVG`, `zoomSVG` (set value to empty string `''` if you want to remove the icon), these options support any HTML string.

For example:

<PswpCodePreview>

```js pswpcode
import PhotoSwipeLightbox from '/photoswipe/photoswipe-lightbox.esm.js';

const leftArrowSVGString = '<svg aria-hidden="true" class="pswp__icn" viewBox="0 0 100 125" width="100" height="125"><path d="M5,50L50,5l3,3L11,50l42,42l-3,3L5,50z M92,95l3-3L53,50L95,8l-3-3L47,50L92,95z"/></svg>';

const options = {
  arrowPrevSVG: leftArrowSVGString,
  arrowNextSVG: leftArrowSVGString,

  // to apply styles just to this instance of PhotoSwipe
  mainClass: 'pswp--custom-icon-colors',

  gallery: '#gallery--custom-icon-colors',
  children: 'a',
  pswpModule: () => import('/photoswipe/photoswipe.esm.js')
};
const lightbox = new PhotoSwipeLightbox(options);
lightbox.init();
```

```css pswpcode
.pswp--custom-icon-colors {
  --pswp-icon-color: #00fffc;
  --pswp-icon-color-secondary: #333;
}
```

```html pswpcode
<div class="pswp-gallery" id="gallery--custom-icon-colors">
  <a href="https://source.unsplash.com/Volo9FYUAzU/1620x1080" 
    data-pswp-width="1620" 
    data-pswp-height="1080" 
    target="_blank">
    <img src="https://source.unsplash.com/Volo9FYUAzU/162x108" alt="" />
  </a>
  <a href="https://source.unsplash.com/WLUHO9A_xik/1600x900" 
    data-pswp-width="1600" 
    data-pswp-height="900" 
    target="_blank">
    <img src="https://source.unsplash.com/WLUHO9A_xik/160x90" alt="" />
  </a>
  <a href="https://source.unsplash.com/RJzHlbKf6eY/1950x1300" 
    data-pswp-width="1950" 
    data-pswp-height="1300" 
    target="_blank">
    <img src="https://source.unsplash.com/RJzHlbKf6eY/195x130" alt="" />
  </a>
</div>
```

</PswpCodePreview>

- Use SVGO to optimize icons. ([SVGOMG online tool](https://jakearchibald.github.io/svgomg/)).
- Add `pswp__icn` class, define `viewBox`, `width`, `height` and `aria-hidden="true"` attributes.

```html
<svg aria-hidden="true" class="pswp__icn" viewBox="0 0 50 30" width="50" height="30">
  your svg content
</svg>
```


## Hiding a specific UI element

Elements can be disabled by their name, for example:

```
arrowPrev: false,
arrowNext: false,
zoom: false,
close: false,
counter: false
```

You may also hide them via CSS, for example:

```
.pswp__counter {
  display: none;
}
```

## Background color and opacity

Background color can be controlled via CSS variable `.pswp { --pswp-bg: red; }` or directly `.pswp__bg { background: red; }`

To adjust opacity - use JS option `bgOpacity`, for example `bgOpacity: 0.6`.

- If you need transparency - do not use rgba color to define background of the PhotoSwipe, it affects the performance.
- Do no try to apply blur to the background of PhotoSwipe, as it also heavily affects the performance.

<PswpCodePreview numItems="4" galleryID="custom-bg">

```js pswpcode
import PhotoSwipeLightbox from '/photoswipe/photoswipe-lightbox.esm.js';

const options = {
  // set background opacity
  bgOpacity: 0.6,

  // to apply styles just to this instance of PhotoSwipe
  mainClass: 'pswp--custom-bg',

  gallery: '#gallery--custom-bg',
  children: 'a',
  pswpModule: () => import('/photoswipe/photoswipe.esm.js')
};
const lightbox = new PhotoSwipeLightbox(options);
lightbox.init();
```

```css pswpcode
.pswp--custom-bg {
  --pswp-bg: #7079bf;
}
```

</PswpCodePreview>

## Loading indicator (preloader)

If you have a good connection, you probably haven't even seen the loading indicator. That's because PhotoSwipe displays loading indicator only if image is not loaded within 2 seconds (can be adjusted via [preloaderDelay](options#preloaderDelay) option). Use dev tools network throttling to test it.

The default loading indicator is displayed in the top left corner and is just a spinning 3/4 circle. You may adjust it just via CSS, the default styles are in `photoswipe.css`.

The example below permanently displays it for debugging:

<PswpCodePreview numItems="4" galleryID="perma-preloader">

```js pswpcode
import PhotoSwipeLightbox from '/photoswipe/photoswipe-lightbox.esm.js';
const lightbox = new PhotoSwipeLightbox({
  gallery: '#gallery--perma-preloader',
  children: 'a',
  pswpModule: () => import('/photoswipe/photoswipe.esm.js'),
  mainClass: 'pswp-with-perma-preloader',
});
lightbox.init();
```

```css pswpcode 
/* debug: permanently display preloader */
.pswp-with-perma-preloader .pswp__icn {
  opacity: 0.85 !important;
}
```

</PswpCodePreview>